<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class ElectiveCI extends CI_Controller {

	public function __construct()
	{
		parent:: __construct();
		$this->load->model('ElectiveMD');
	}

	public function index()
	{
	if(!$this->session->islogged_in){
		$this->form_validation->set_error_delimiters("<div class='alert alert-danger'>","</div>");
		$this->form_validation->set_rules('username', 'username', 'required');
		$this->form_validation->set_rules('password', 'password', 'required');

		if($this->form_validation->run()==FALSE){
		
		//$original_string = array_merge(range(0, 9), range('a', 'z'), range('A', 'Z'));
		//$original_string = implode("", $original_string);
		//$captcha = substr(str_shuffle($original_string), 0, 6);
		
		$captcha = substr(number_format(time() * rand(), 0, '', ''), 0, 8);
		
		$vals = array(
			'word' => $captcha,
			'img_path' => './assets/captchaimg/',
			'img_url' => base_url().'assets/captchaimg/',
			'font_path' => base_url().'system/fonts/captcha.ttf',
			'font_size' => 12,
			'img_width' => 150,
			'img_height' => 50,
			'expiration' => 7700,
			'colors'            => array(
				'background' => array(171, 194, 177),
				'border' => array(10, 51, 11),
				'text' => array(105, 105, 105),
				'grid' => array(185, 234, 237)
				)
			);
			$cap = create_captcha($vals);
			$this->session->unset_userdata('guessword');
			$this->session->set_userdata('guessword', $captcha);
			$data['image'] = $cap['image'];
			
			$page = "login";
			
			if(!file_exists(APPPATH.'views/adminpages/'.$page.'.php')){
				show_404();
			}

		$this->load->view('templates/header');
		$this->load->view('templates/adminmenu3');
		$this->load->view('adminpages/'.$page);
		$this->load->view('templates/footer');

		}else{
		//READ CAPTCHA
		$captcha_response = trim($this->input->post('g-recaptcha-response'));
		$sessCaptcha = $this->session->userdata('guessword');
		
		if($captcha_response == $sessCaptcha){
		  $this->session->unset_userdata('guessword');
		  $attempts = $this->ElectiveMD->getLoginAttempt();
		  if(is_iterable($attempts) && $attempts > 0){
		  $attempt = $attempts['attempt'];
		  
		  if($attempt < 3){
			$user = $this->ElectiveMD->login();
			if($user){
			
				$userid = $user['userid'];
				$username = $user['username'];
				
				$this->sendappotp($username, $userid,);
			}else{
				$flashmessages = array(
				    'message' => 'Invalid username/password',
				    'status' => 'negative'
				);
				$this->session->set_userdata('flashmessages', $flashmessages);
				//$this->session->set_flashdata('failed_login',' Invalid//username/password');
				
				$attempt++;
				
				$result = $this->HRMS_Model->insertLoginAttempt($attempt);
				
				redirect(base_url(). "login");
			}	
				}else{
				$email = $this->input->post('username', true);
				$password = $this->input->post('password', true);
				$appapi = $this->checkApplicationAPI($email, $password);
				if($appapi){
					$user = $this->ElectiveMD->login();
					if($user){
					
						$userid = $user['userid'];
						$username = $user['username'];
						
						$this->sendappotp($username, $userid,);
						
					}else{
						$flashmessages = array(
						'message' => 'Invalid username/password',
						'status' => 'negative'
						);
						
						$this->session->set_userdata('flashmessages', $flashmessages);
						//$this->session->set_flashdata('failed_login',' Invalid//username/password');
						
						$attempt=1;
						
						$result = $this->HRMS_Model->insertLoginAttempt($attempt);
						
						redirect(base_url(). "login");
					}
					
					}else{
						$flashmessages = array(
						'message' => 'Invalid username/password',
						'status' => 'negative'
						);
						
						$this->session->set_userdata('flashmessages', $flashmessages);
						redirect(base_url(). "login");
					}
				}
		
				
		
			redirect(base_url()."dashboard");
				}
			}
		}
	}
}
	
	public function refreshcaptcha(){
		if(!this->input->is_ajax_request()){
			exit('No direct script access allowed');
		}
		
		$captcha = substr(number_format(time() * rand(), 0, '', ''), 0, 8);
		
		$vals = array(
			'word' => $captcha,
			'img_path' => './assets/captchaimg/',
			'img_url' => base_url().'assets/captchaimg/',
			'font_path' => base_url().'system/fonts/captcha.ttf',
			'font_size' => 12,
			'img_width' => 150,
			'img_height' => 50,
			'expiration' => 7700,
			'colors'            => array(
				'background' => array(171, 194, 177),
				'border' => array(10, 51, 11),
				'text' => array(105, 105, 105),
				'grid' => array(185, 234, 237)
				)
			);
			$cap = create_captcha($vals);
			$this->session->unset_userdata('guessword');
			$this->session->set_userdata('guessword', $captcha);
			echo $cap['image'];
	}
	
	public function sendappotp($emailaddress, $employeeid, $userid){
		$result = $this->ElectiveMD->sendOTP($emailaddress, $userid);
		
		if($result){
			$data['userid'] = $userid;
			$data['username'] = $username;
			
			$page = 'otppage';
			$this->load->view('templates/header');
			$this->load->view('templates/adminmenu3');
			$this->load->view('adminpages/'.$page);
			$this->load->view('templates/footer');
		}else{
			$flashmessages = array(
			'message' => 'Invalid username/password',
			'status' => 'negative'
			);
			$this->session->set_userdata('flashmessages', $flashmessages);
			redirect(base_url(). "login");
		}
	}
			
			
	
	public function sendmail()
	{
		$emailaddress = "22101309-student@ndu.edu.ph";
		$this->load->library('phpmailer_lib');

		// PHPMailer object
		$mail = $this->phpmailer_lib->load();

		$mail->isSMTP();
		$mail->Host = 'smtp.hostinger.com';
		// $mail->SMTPDebug = 2; // Enable verbose debug output
		$mail->SMTPAuth = true;
		$mail->Username = 'noreply@sample.nduelect.com';
		$mail->Password = '';
		$mail->SMTPSecure = 'ssl';
		$mail->Port = 465;

		$mail->setFrom('noreply@progpad.com', 'PWD Information');
		$mail->addReplyTo('noreply@progpad.com', 'PWD Information');
		$mail->addAddress($emailaddress);
		$mail->Subject = 'PSITS General Assembly';
		$mail->isHTML(true);

		$mailContent = 'Im trying to sample this mail.';
		$mail->Body = $mailContent;

		if (!$mail->send()) {
			return 'Message could not be sent. Mailer Error: ' . $mail->ErrorInfo;
		} else {
			return 'Message has been sent';
		}
	}

	public function logout(){
	    $this->session->unset_userdata('userid');
	    $this->session->unset_userdata('accountname');
	    $this->session->unset_userdata('username');
	    $this->session->unset_userdata('usertype');
	    $this->session->unset_userdata('userstatus');
	    $this->session->unset_userdata('islogged_in');
	    $this->session->sess_destroy();
	    redirect(base_url());
	}

	public function dashboard(){
		if($this->session->islogged_in){
			if($this->session->usertype == "System Administrator"){
				$this->load->view('templates/header');
				$this->load->view('templates/adminmenu');
				$this->load->view('templates/footer');
			}else{
				redirect(base_url());
			}
		}else{
			redirect(base_url());
		}
	}

	public function getSubjects(){
		if($this->session->islogged_in){
		$dstp = "";
		if ($this->input->post('filtersubject') != NULL){
			$dstp = $this->input->post("lname", true);
			$dstp = !empty($dstp) ? $dstp : "";

			$filterdata = array(
				'dstp' => $dstp
			);
			$this->session->set_userdata('filterdata', $filterdata);
		} else {
			$filterdata = $this->session->userdata('filterdata');
			$dstp = !empty($filterdata['dstp']) ? $filterdata['dstp'] : "";
		}

		if ($this->input->post('clearsubject') != NULL){
		$this->session->unset_userdata('filterdata');
		$dstp = "";
		}

		$recordno = 4;
		$config = array();
		$config['base_url'] = base_url(). "subject";
		$config['total_rows'] = $this->ElectiveMD->countSubject($dstp);
		$config['per_page'] = $recordno;
		$config['url_segment'] = 2;

		$config['full_tag_open'] = '<ul class="pagination">';
		$config['Full_tag_close'] = '</ul>';
		$config['first_link'] = 'First';
		$config['last_link'] = 'Last';
		$config['first_tag_open'] = '<li class="page-item"><span class="page-link">';
		$config['first_tag_close'] = '</span></li>';
		$config['prev_link'] = '&laquo';
		$config['prev_tag_open'] = '<li class="page-item"><span class="page-link">';
		$config['prev_tag_close'] = '</span></li>';
		$config['next_link'] = '&raquo';
		$config['next_tag_open'] = '<li class="page-item"><span class="page-link">';
		$config['next_tag_close'] = '</span></li>';
		$config['last_tag_open'] = '<li class="page-item"><span class="page-link">';
		$config['last_tag_close'] = '</span></li>';
		$config['cur_tag_open'] = '<li class="page-item active"><a class="page-link" href="#">';
		$config['cur_tag_close'] = '</a></li>';
		$config['num_tag_open'] = '<li class="page-item"><span class="page-link">';
		$config['num_tag_close'] = '</span></li>';

		$this->pagination->initialize($config);
		$page = ($this->uri->segment(2)) ? $this->uri->segment(2) : 0;
		$data['count'] = $page;
		$data['total'] = $this->ElectiveMD->countSubject($dstp);

		$config['last_tag_close'] = '</li>';

		$data['links'] = $this->pagination->create_links();

		$data['sub'] = $this->ElectiveMD->getSubjects($config['per_page'], $page, $dstp);
		$data['cnt'] = $page = 1;
		$data['lname'] = $dstp;
		$this->load->view('templates/header');
		$this->load->view('templates/adminmenu2');
		$this->load->view('adminpages/subject', $data);
		$this->load->view('templates/footer');
		}else{
			redirect(base_url());
		}
	}
	
	public function addSubject(){
		if($this->session->islogged_in){
		$this->load->view('templates/header');
		$this->load->view('templates/adminmenu2');
		$this->load->view('adminpages/addsubject');
		$this->load->view('templates/footer');
		}else{
			redirect(base_url());
		}
	}

	public function editSubject($pwdid){
		$subs = $this->ElectiveMD->viewSubject($pwdid);
		if($subs){
		$data['pwdid'] = $subs['pwdid'];
		$data['lname'] = $subs['lname'];
		$data['fname'] = $subs['fname'];
		$data['mname'] = $subs['mname'];
		$data['pwdtype'] = $subs['pwdtype'];
		$data['address'] = $subs['address'];
		$data['birthdate'] = $subs['birthdate'];
		$data['sextype'] = $subs['sextype'];
		$data['issuedate'] = $subs['issuedate'];
		$data['pwdimg'] = $subs['pwdimg'];
		$this->load->view('templates/header');
		$this->load->view('templates/adminmenu2');
		$this->load->view('adminpages/editsubject', $data);
		$this->load->view('templates/footer');
		}else
		redirect(base_url(). "subject");

	}

	public function saveSubject(){
		$result = $this->ElectiveMD->insertSubject();
		if($result){
			$flashmessages = array(
				'message' => 'New information inserted.',
				'status' => 'positive'
			);
			$this->session->set_userdata('flashmessages', $flashmessages);
            redirect('subject');
		}else{
			$flashmessages = array(
				'message' => 'Error encountered.',
				'status' => 'negative'
			);
			$this->session->set_userdata('flashmessages', $flashmessages);
	}
	redirect(base_url(). "subject");
 }

 public function updateSubject(){
		$result = $this->ElectiveMD->updateSubject();
		if($result){
			$flashmessages = array(
				'message' => 'New information updated.',
				'status' => 'positive'
			);
			$this->session->set_userdata('flashmessages', $flashmessages);
			redirect('subject');
		}else{
			$flashmessages = array(
				'message' => 'Error encountered.',
				'status' => 'negative'
			);
			$this->session->set_userdata('flashmessages', $flashmessages);
	}
	redirect(base_url(). "subject");
 }

 public function deleteSubject($pwdid){
 	$result = $this->ElectiveMD->deleteSubject($pwdid);
 	redirect(base_url(). 'subject');
 }

 public function event(){
		
		if($this->session->islogged_in){
			$event_data = $this->ElectiveMD->getEventCalendar();
			$data['data'][] = array();
			foreach($event_data as $row)
			{
				$data['data'][] = array(
					"title" => $row['eventtitle'],
					"start" => $row['eventstartdate'],
					"end" => $row['eventenddate'],
	            	"backgroundColor" => "#00a65a"
				);
			}
			$page = "event";
			$this->load->view('templates/header');
			$this->load->view('templates/adminmenu2');
			$this->load->view('adminpages/'.$page, $data);
			$this->load->view('templates/footer');
		}else
			redirect(base_url()."dashboard");
	}
	
	public function addevent(){
		if($this->session->islogged_in){
		$this->load->view('templates/header');
		$this->load->view('templates/adminmenu2');
		$this->load->view('adminpages/addevent');
		$this->load->view('templates/footer');
		}else{
			redirect(base_url());
		}
	}

	public function viewevent($eventtitle){
		if($this->session->islogged_in){
			$eventtitle = urldecode($eventtitle);
			$subs = $this->ElectiveMD->getEvent($eventtitle);
			if($subs){
				$data['eventid'] = $subs['eventid'];
				$data['eventtitle'] = $subs['eventtitle'];
				$data['eventstartdate'] = $subs['eventstartdate'];
				$data['eventenddate'] = $subs['eventenddate'];
				$data['eventimage'] = $subs['eventimage'];

				$this->load->view('templates/header');
				$this->load->view('templates/adminmenu2');
				$this->load->view('adminpages/viewevent', $data);
				$this->load->view('templates/footer');
			}else
				redirect(base_url()."event");
		}else
			redirect(base_url());
			
	}

	public function editevent($eventid){
		if($this->session->islogged_in){
			$subs = $this->ElectiveMD->getEventByID($eventid);
			if($subs){
				$data['eventid'] = $subs['eventid'];
				$data['eventtitle'] = $subs['eventtitle'];
				$data['eventstartdate'] = $subs['eventstartdate'];
				$data['eventenddate'] = $subs['eventenddate'];
				$data['eventimage'] = $subs['eventimage'];

				$this->load->view('templates/header');
				$this->load->view('templates/adminmenu2');
				$this->load->view('adminpages/editevent', $data);
				$this->load->view('templates/footer');
			}else
				redirect(base_url()."event");
		}else
			redirect(base_url());
			
	}

	public function updateevent(){
		$eventimage = "";
		if(!empty($_FILES['eventimage']['name'])){
			$_FILES['event']['name'] = $_FILES['eventimage']['name'];
			$_FILES['event']['type'] = $_FILES['eventimage']['type'];
			$_FILES['event']['tmp_name'] = $_FILES['eventimage']['tmp_name'];
			$_FILES['event']['error'] = $_FILES['eventimage']['error'];
			$_FILES['event']['size'] = $_FILES['eventimage']['size'];

			$config = array(
				'upload_path' => "./assets/eventimage/",
				'allowed_types' => "gif|jpg|png|jpeg|bmp",
				'overwrite' => TRUE,
				'max_size' =>  "104857600",
				'max_height' => "6000",
				'max_width' => "5000",
				'encrypt_name' => TRUE,
				'detect_mime' => TRUE,
				'file_name' => $_FILES['event']['name']
			);

			$this->load->library('upload', $config);
			$this->upload->initialize($config);
			
			if($this->upload->do_upload('event')){
				//With evidence uploaded
				$uploadData = $this->upload->data();
				$eventimage = $uploadData['file_name'];

			}
		}

		$result = $this->ElectiveMD->updateEvent($eventimage);
		
		if($result){
			$flashmessages = array(
			    'message' => ' Event has been updated.',
			    'status' => 'positive'
			);
			$this->session->set_userdata('flashmessages', $flashmessages);
		}else{
			$flashmessages = array(
			    'message' => ' Error encountered.',
			    'status' => 'negative'
			);
			$this->session->set_userdata('flashmessages', $flashmessages);
		}
		redirect(base_url()."event");
	}
	
	public function saveevent(){
		$result = $this->ElectiveMD->insertevent();
		if($result){
			$flashmessages = array(
				'message' => 'New information inserted.',
				'status' => 'positive'
			);
			$this->session->set_userdata('flashmessages', $flashmessages);
            redirect('subject');
		}else{
			$flashmessages = array(
				'message' => 'Error encountered.',
				'status' => 'negative'
			);
			$this->session->set_userdata('flashmessages', $flashmessages);
	}
	redirect(base_url(). "event");
	}

	public function getCommunications(){
		if($this->session->islogged_in){
		$dstp = "";
		if ($this->input->post('filtercommunication') != NULL){
			$dstp = $this->input->post("lname", true);
			$dstp = !empty($dstp) ? $dstp : "";

			$filterdata = array(
				'dstp' => $dstp
			);
			$this->session->set_userdata('filterdata', $filterdata);
		} else {
			$filterdata = $this->session->userdata('filterdata');
			$dstp = !empty($filterdata['dstp']) ? $filterdata['dstp'] : "";
		}

		if ($this->input->post('clearcommunication') != NULL){
		$this->session->unset_userdata('filterdata');
		$dstp = "";
		}

		$recordno = 4;
		$config = array();
		$config['base_url'] = base_url(). "communication";
		$config['total_rows'] = $this->ElectiveMD->countCommunication($dstp);
		$config['per_page'] = $recordno;
		$config['url_segment'] = 2;

		$config['full_tag_open'] = '<ul class="pagination">';
		$config['Full_tag_close'] = '</ul>';
		$config['first_link'] = 'First';
		$config['last_link'] = 'Last';
		$config['first_tag_open'] = '<li class="page-item"><span class="page-link">';
		$config['first_tag_close'] = '</span></li>';
		$config['prev_link'] = '&laquo';
		$config['prev_tag_open'] = '<li class="page-item"><span class="page-link">';
		$config['prev_tag_close'] = '</span></li>';
		$config['next_link'] = '&raquo';
		$config['next_tag_open'] = '<li class="page-item"><span class="page-link">';
		$config['next_tag_close'] = '</span></li>';
		$config['last_tag_open'] = '<li class="page-item"><span class="page-link">';
		$config['last_tag_close'] = '</span></li>';
		$config['cur_tag_open'] = '<li class="page-item active"><a class="page-link" href="#">';
		$config['cur_tag_close'] = '</a></li>';
		$config['num_tag_open'] = '<li class="page-item"><span class="page-link">';
		$config['num_tag_close'] = '</span></li>';

		$this->pagination->initialize($config);
		$page = ($this->uri->segment(2)) ? $this->uri->segment(2) : 0;
		$data['count'] = $page;
		$data['total'] = $this->ElectiveMD->countCommunication($dstp);

		$config['last_tag_close'] = '</li>';

		$data['links'] = $this->pagination->create_links();

		$data['sub'] = $this->ElectiveMD->getCommunications($config['per_page'], $page, $dstp);
		$data['cnt'] = $page = 1;
		$data['lname'] = $dstp;
		$this->load->view('templates/header');
		$this->load->view('templates/adminmenu2');
		$this->load->view('adminpages/communication', $data);
		$this->load->view('templates/footer');
		}else{
			redirect(base_url());
		}
	}

	public function getChronicills(){
		if($this->session->islogged_in){
		$dstp = "";
		if ($this->input->post('filterchronicill') != NULL){
			$dstp = $this->input->post("lname", true);
			$dstp = !empty($dstp) ? $dstp : "";

			$filterdata = array(
				'dstp' => $dstp
			);
			$this->session->set_userdata('filterdata', $filterdata);
		} else {
			$filterdata = $this->session->userdata('filterdata');
			$dstp = !empty($filterdata['dstp']) ? $filterdata['dstp'] : "";
		}

		if ($this->input->post('clearchronicill') != NULL){
		$this->session->unset_userdata('filterdata');
		$dstp = "";
		}

		$recordno = 4;
		$config = array();
		$config['base_url'] = base_url(). "chronicill";
		$config['total_rows'] = $this->ElectiveMD->countChronicill($dstp);
		$config['per_page'] = $recordno;
		$config['url_segment'] = 2;

		$config['full_tag_open'] = '<ul class="pagination">';
		$config['Full_tag_close'] = '</ul>';
		$config['first_link'] = 'First';
		$config['last_link'] = 'Last';
		$config['first_tag_open'] = '<li class="page-item"><span class="page-link">';
		$config['first_tag_close'] = '</span></li>';
		$config['prev_link'] = '&laquo';
		$config['prev_tag_open'] = '<li class="page-item"><span class="page-link">';
		$config['prev_tag_close'] = '</span></li>';
		$config['next_link'] = '&raquo';
		$config['next_tag_open'] = '<li class="page-item"><span class="page-link">';
		$config['next_tag_close'] = '</span></li>';
		$config['last_tag_open'] = '<li class="page-item"><span class="page-link">';
		$config['last_tag_close'] = '</span></li>';
		$config['cur_tag_open'] = '<li class="page-item active"><a class="page-link" href="#">';
		$config['cur_tag_close'] = '</a></li>';
		$config['num_tag_open'] = '<li class="page-item"><span class="page-link">';
		$config['num_tag_close'] = '</span></li>';

		$this->pagination->initialize($config);
		$page = ($this->uri->segment(2)) ? $this->uri->segment(2) : 0;
		$data['count'] = $page;
		$data['total'] = $this->ElectiveMD->countChronicill($dstp);

		$config['last_tag_close'] = '</li>';

		$data['links'] = $this->pagination->create_links();

		$data['sub'] = $this->ElectiveMD->getChronicills($config['per_page'], $page, $dstp);
		$data['cnt'] = $page = 1;
		$data['lname'] = $dstp;
		$this->load->view('templates/header');
		$this->load->view('templates/adminmenu2');
		$this->load->view('adminpages/chronicill', $data);
		$this->load->view('templates/footer');
		}else{
			redirect(base_url());
		}
	}

	public function getLearnings(){
		if($this->session->islogged_in){
		$dstp = "";
		if ($this->input->post('filterlearning') != NULL){
			$dstp = $this->input->post("lname", true);
			$dstp = !empty($dstp) ? $dstp : "";

			$filterdata = array(
				'dstp' => $dstp
			);
			$this->session->set_userdata('filterdata', $filterdata);
		} else {
			$filterdata = $this->session->userdata('filterdata');
			$dstp = !empty($filterdata['dstp']) ? $filterdata['dstp'] : "";
		}

		if ($this->input->post('clearlearning') != NULL){
		$this->session->unset_userdata('filterdata');
		$dstp = "";
		}

		$recordno = 4;
		$config = array();
		$config['base_url'] = base_url(). "learning";
		$config['total_rows'] = $this->ElectiveMD->countLearning($dstp);
		$config['per_page'] = $recordno;
		$config['url_segment'] = 2;

		$config['full_tag_open'] = '<ul class="pagination">';
		$config['Full_tag_close'] = '</ul>';
		$config['first_link'] = 'First';
		$config['last_link'] = 'Last';
		$config['first_tag_open'] = '<li class="page-item"><span class="page-link">';
		$config['first_tag_close'] = '</span></li>';
		$config['prev_link'] = '&laquo';
		$config['prev_tag_open'] = '<li class="page-item"><span class="page-link">';
		$config['prev_tag_close'] = '</span></li>';
		$config['next_link'] = '&raquo';
		$config['next_tag_open'] = '<li class="page-item"><span class="page-link">';
		$config['next_tag_close'] = '</span></li>';
		$config['last_tag_open'] = '<li class="page-item"><span class="page-link">';
		$config['last_tag_close'] = '</span></li>';
		$config['cur_tag_open'] = '<li class="page-item active"><a class="page-link" href="#">';
		$config['cur_tag_close'] = '</a></li>';
		$config['num_tag_open'] = '<li class="page-item"><span class="page-link">';
		$config['num_tag_close'] = '</span></li>';

		$this->pagination->initialize($config);
		$page = ($this->uri->segment(2)) ? $this->uri->segment(2) : 0;
		$data['count'] = $page;
		$data['total'] = $this->ElectiveMD->countLearning($dstp);

		$config['last_tag_close'] = '</li>';

		$data['links'] = $this->pagination->create_links();

		$data['sub'] = $this->ElectiveMD->getlearnings($config['per_page'], $page, $dstp);
		$data['cnt'] = $page = 1;
		$data['lname'] = $dstp;
		$this->load->view('templates/header');
		$this->load->view('templates/adminmenu2');
		$this->load->view('adminpages/learning', $data);
		$this->load->view('templates/footer');
		}else{
			redirect(base_url());
		}
	}

	public function getIntellectuals(){
		if($this->session->islogged_in){
		$dstp = "";
		if ($this->input->post('filterintellectual') != NULL){
			$dstp = $this->input->post("lname", true);
			$dstp = !empty($dstp) ? $dstp : "";

			$filterdata = array(
				'dstp' => $dstp
			);
			$this->session->set_userdata('filterdata', $filterdata);
		} else {
			$filterdata = $this->session->userdata('filterdata');
			$dstp = !empty($filterdata['dstp']) ? $filterdata['dstp'] : "";
		}

		if ($this->input->post('clearintellectual') != NULL){
		$this->session->unset_userdata('filterdata');
		$dstp = "";
		}

		$recordno = 4;
		$config = array();
		$config['base_url'] = base_url(). "intellectual";
		$config['total_rows'] = $this->ElectiveMD->countIntellectual($dstp);
		$config['per_page'] = $recordno;
		$config['url_segment'] = 2;

		$config['full_tag_open'] = '<ul class="pagination">';
		$config['Full_tag_close'] = '</ul>';
		$config['first_link'] = 'First';
		$config['last_link'] = 'Last';
		$config['first_tag_open'] = '<li class="page-item"><span class="page-link">';
		$config['first_tag_close'] = '</span></li>';
		$config['prev_link'] = '&laquo';
		$config['prev_tag_open'] = '<li class="page-item"><span class="page-link">';
		$config['prev_tag_close'] = '</span></li>';
		$config['next_link'] = '&raquo';
		$config['next_tag_open'] = '<li class="page-item"><span class="page-link">';
		$config['next_tag_close'] = '</span></li>';
		$config['last_tag_open'] = '<li class="page-item"><span class="page-link">';
		$config['last_tag_close'] = '</span></li>';
		$config['cur_tag_open'] = '<li class="page-item active"><a class="page-link" href="#">';
		$config['cur_tag_close'] = '</a></li>';
		$config['num_tag_open'] = '<li class="page-item"><span class="page-link">';
		$config['num_tag_close'] = '</span></li>';

		$this->pagination->initialize($config);
		$page = ($this->uri->segment(2)) ? $this->uri->segment(2) : 0;
		$data['count'] = $page;
		$data['total'] = $this->ElectiveMD->countIntellectual($dstp);

		$config['last_tag_close'] = '</li>';

		$data['links'] = $this->pagination->create_links();

		$data['sub'] = $this->ElectiveMD->getIntellectuals($config['per_page'], $page, $dstp);
		$data['cnt'] = $page = 1;
		$data['lname'] = $dstp;
		$this->load->view('templates/header');
		$this->load->view('templates/adminmenu2');
		$this->load->view('adminpages/intellectual', $data);
		$this->load->view('templates/footer');
		}else{
			redirect(base_url());
		}
	}

	public function getOrthopedics(){
		if($this->session->islogged_in){
		$dstp = "";
		if ($this->input->post('filterorthopedic') != NULL){
			$dstp = $this->input->post("lname", true);
			$dstp = !empty($dstp) ? $dstp : "";

			$filterdata = array(
				'dstp' => $dstp
			);
			$this->session->set_userdata('filterdata', $filterdata);
		} else {
			$filterdata = $this->session->userdata('filterdata');
			$dstp = !empty($filterdata['dstp']) ? $filterdata['dstp'] : "";
		}

		if ($this->input->post('clearorthopedic') != NULL){
		$this->session->unset_userdata('filterdata');
		$dstp = "";
		}

		$recordno = 4;
		$config = array();
		$config['base_url'] = base_url(). "orthopedic";
		$config['total_rows'] = $this->ElectiveMD->countOrthopedic($dstp);
		$config['per_page'] = $recordno;
		$config['url_segment'] = 2;

		$config['full_tag_open'] = '<ul class="pagination">';
		$config['Full_tag_close'] = '</ul>';
		$config['first_link'] = 'First';
		$config['last_link'] = 'Last';
		$config['first_tag_open'] = '<li class="page-item"><span class="page-link">';
		$config['first_tag_close'] = '</span></li>';
		$config['prev_link'] = '&laquo';
		$config['prev_tag_open'] = '<li class="page-item"><span class="page-link">';
		$config['prev_tag_close'] = '</span></li>';
		$config['next_link'] = '&raquo';
		$config['next_tag_open'] = '<li class="page-item"><span class="page-link">';
		$config['next_tag_close'] = '</span></li>';
		$config['last_tag_open'] = '<li class="page-item"><span class="page-link">';
		$config['last_tag_close'] = '</span></li>';
		$config['cur_tag_open'] = '<li class="page-item active"><a class="page-link" href="#">';
		$config['cur_tag_close'] = '</a></li>';
		$config['num_tag_open'] = '<li class="page-item"><span class="page-link">';
		$config['num_tag_close'] = '</span></li>';

		$this->pagination->initialize($config);
		$page = ($this->uri->segment(2)) ? $this->uri->segment(2) : 0;
		$data['count'] = $page;
		$data['total'] = $this->ElectiveMD->countOrthopedic($dstp);

		$config['last_tag_close'] = '</li>';

		$data['links'] = $this->pagination->create_links();

		$data['sub'] = $this->ElectiveMD->getOrthopedics($config['per_page'], $page, $dstp);
		$data['cnt'] = $page = 1;
		$data['lname'] = $dstp;
		$this->load->view('templates/header');
		$this->load->view('templates/adminmenu2');
		$this->load->view('adminpages/orthopedic', $data);
		$this->load->view('templates/footer');
		}else{
			redirect(base_url());
		}
	}

	public function getPsychosocials(){
		if($this->session->islogged_in){
		$dstp = "";
		if ($this->input->post('filterpsychosocial') != NULL){
			$dstp = $this->input->post("lname", true);
			$dstp = !empty($dstp) ? $dstp : "";

			$filterdata = array(
				'dstp' => $dstp
			);
			$this->session->set_userdata('filterdata', $filterdata);
		} else {
			$filterdata = $this->session->userdata('filterdata');
			$dstp = !empty($filterdata['dstp']) ? $filterdata['dstp'] : "";
		}

		if ($this->input->post('clearpsychosocial') != NULL){
		$this->session->unset_userdata('filterdata');
		$dstp = "";
		}

		$recordno = 4;
		$config = array();
		$config['base_url'] = base_url(). "psychosocial";
		$config['total_rows'] = $this->ElectiveMD->countPsychosocial($dstp);
		$config['per_page'] = $recordno;
		$config['url_segment'] = 2;

		$config['full_tag_open'] = '<ul class="pagination">';
		$config['Full_tag_close'] = '</ul>';
		$config['first_link'] = 'First';
		$config['last_link'] = 'Last';
		$config['first_tag_open'] = '<li class="page-item"><span class="page-link">';
		$config['first_tag_close'] = '</span></li>';
		$config['prev_link'] = '&laquo';
		$config['prev_tag_open'] = '<li class="page-item"><span class="page-link">';
		$config['prev_tag_close'] = '</span></li>';
		$config['next_link'] = '&raquo';
		$config['next_tag_open'] = '<li class="page-item"><span class="page-link">';
		$config['next_tag_close'] = '</span></li>';
		$config['last_tag_open'] = '<li class="page-item"><span class="page-link">';
		$config['last_tag_close'] = '</span></li>';
		$config['cur_tag_open'] = '<li class="page-item active"><a class="page-link" href="#">';
		$config['cur_tag_close'] = '</a></li>';
		$config['num_tag_open'] = '<li class="page-item"><span class="page-link">';
		$config['num_tag_close'] = '</span></li>';

		$this->pagination->initialize($config);
		$page = ($this->uri->segment(2)) ? $this->uri->segment(2) : 0;
		$data['count'] = $page;
		$data['total'] = $this->ElectiveMD->countPsychosocial($dstp);

		$config['last_tag_close'] = '</li>';

		$data['links'] = $this->pagination->create_links();

		$data['sub'] = $this->ElectiveMD->getPsychosocials($config['per_page'], $page, $dstp);
		$data['cnt'] = $page = 1;
		$data['lname'] = $dstp;
		$this->load->view('templates/header');
		$this->load->view('templates/adminmenu2');
		$this->load->view('adminpages/psychosocial', $data);
		$this->load->view('templates/footer');
		}else{
			redirect(base_url());
		}
	}

	public function viewPwds($pwdid){
		$pwdid = $this->ElectiveMD->getPwds($pwdid);
		$this->load->view('templates/header');
		$this->load->view('templates/adminmenu2');
		$this->load->view('adminpages/pwdview', $pwdid);
		$this->load->view('templates/footer');
	}

	public function disablity()
	{
		$data['crs'] = $this->WebDevModel->getDisabilities();
		$this->load->view('templates/header');
		$this->load->view('templates/adminmenus');
		$this->load->view('pages/disability', $data);
		$this->load->view('templates/footer');
	}
}