
   <div class="card mb-4">
    <div class="card-header d-flex justify-content-between align-items-center">
            <div>
                <i class="fas fa-table me-1"></i>
                Employee Information
            </div>
            <button class="btn btn-primary" data-toggle="modal" data-target="#exampleModal">
                Add Staff
            </button>
        </div>
   


    <div class="table-responsive">
    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th colspan="7" class="text-right">
                    <form action="<?php echo base_url('Staff_controller/staff_information'); ?>" method="post" class="d-flex">
                        <input class="form-control w-25" type="text" name="searchKeyword" 
                            value="<?php echo set_value('searchKeyword'); ?>" placeholder="Search Staff..." />
                        <button class="btn btn-info" type="submit" name="submitSearch"> 
                            <i class="fas fa-search"></i>
                        </button>                            
                        <input type="submit" name="submitSearchReset" class="btn btn-secondary" value="Clear" style="width: 70px;">
                    </form>
                </th>
                </tr>
                
                <tr>
                    <th>#</th>
                    <th>First Name</th>
                    <th>Last Name</th>
                    <th>Gender</th>
                    <th>Email</th>
                    <th>Contact Number</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php   
                foreach ($employee_information as $staff_crud): ?>
                    <tr>
                        <td><?php echo $staff_crud->staff_id; ?></td>
                        <td><?php echo $staff_crud->firstname; ?></td>
                        <td><?php echo $staff_crud->lastname; ?></td>
                        <td><?php echo $staff_crud->gender; ?></td>
                        <td><?php echo $staff_crud->email; ?></td>
                        <td><?php echo $staff_crud->contact_no; ?></td>
                        <td>
                            <a href="<?php echo base_url('Staff_controller/editStaff/' . $staff_crud->staff_id); ?>" 
                                class="btn btn-success">Edit</a>
                             
                            <a href="<?php echo base_url('Staff_controller/deleteStaff/' . $staff_crud->staff_id); ?>" 
                              class='btn btn-danger btn-sm' 
                              onclick="return confirm('Are you sure you want to delete this staff record?');"
                            >Delete</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>



<!-- Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <form action="<?php echo base_url() ?>Staff_controller/addStaff" method="post">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Add Staff</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div class="form-group">
         <label for="firstname">First Name</label> 
         <input type="text" name="firstname" placeholder="First Name" class="form-control">
         </div>
         <div class="form-group">
         <label for="lastname">Last Name</label> 
         <input type="text" name="lastname" placeholder="Last Name" class="form-control">
         <div class="form-group">
            <label for="gender">Gender</label>
            <select name="gender" class="form-control" required>
              <option value="">Select Gender</option> 
              <option value="Male">Male</option>
              <option value="Female">Female</option>

            </select>
          </div>
         <div class="form-group">
         <label for="email">Email</label> 
         <input type="text" name="email" placeholder="Email" class="form-control">
         </div>
         <div class="form-group">
         <label for="contact_no">Contact Number</label> 
         <input type="text" name="contact_no" placeholder="Contact Number" class="form-control">
         </div>

      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
        <input type="submit" name="insert" value="Add Staff" class="btn btn-info"> 
      </div>
   </form>
    </div>
  </div>
</div>   
</div>

<?php if($this->session->flashdata('error')): ?>

    <div align="center" style="color: #FFF" class="btn-danger">
        <?php echo $this->session->flashdata('error'); ?>
    </div>
<?php endif; ?>

<?php if($this->session->flashdata('inserted')): ?>
    <div align="center" style="color: #FFF" class="btn-success">
        <?php echo $this->session->flashdata('inserted'); ?>
    </div>
<?php endif; ?>

<?php if($this->session->flashdata('updated')): ?>
    <div align="center" style="color: #FFF" class="btn-success">
        <?php echo $this->session->flashdata('updated'); ?>
    </div>
<?php endif; ?>

<?php if($this->session->flashdata('deleted')): ?>

    <div align="center" style="color: #FFF" class="btn-danger">
        <?php echo $this->session->flashdata('del'); ?>
    </div>
<?php endif; ?>




