 <div class="card mb-4">
    <div class="card-header d-flex justify-content-between align-items-center">
        <div>
            <i class="fas fa-table me-1"></i>
            Member Information
        </div>
        <button class="btn btn-primary" data-toggle="modal" data-target="#exampleModal">
            Add Member
        </button>
    </div>
    <div class="table-responsive">
        <table class="table table-striped table-hover table-bordered">
            <thead>
                <tr>
                    <th colspan="7" class="text-right">
                        <form action="" method="post" class="d-flex">
                            <input class="form-control w-25" type="text" name="searchKeyword" 
                                   value="<?php echo isset($searchKeyword) ? $searchKeyword : ''; ?>" 
                                   placeholder="Search for..." />
                            <button class="btn btn-success" type="submit" name="submitSearch"> 
                                <i class="fas fa-search"></i>
                            </button>
                            <input type="submit" name="submitSearchReset" class="btn btn-outline-secondary" value="Clear" style="width: 70px;">
                        </form>
                    </th>
                </tr>
                <tr>
                    <th class="text-center">First Name</th>
                    <th class="text-center">Last Name</th>
                    <th class="text-center">Gender</th>
                    <th class="text-center">Email</th>
                    <th class="text-center">Contact Number</th>
                    <th class="text-center">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php if (!empty($member_information)): ?>
                    <?php foreach ($member_information as $crud): ?>
                        <tr>
                            <td><?php echo $crud->firstname; ?></td>
                            <td><?php echo $crud->lastname; ?></td>
                            <td><?php echo $crud->gender; ?></td>
                            <td><?php echo $crud->email; ?></td>
                            <td><?php echo $crud->contact_no; ?></td>
                            <td>
                                <a href="<?php echo base_url('Visitor_portal/member_status/' . $crud->member_id); ?>" class="btn btn-primary">View Status</a>
                                <a href="<?php echo base_url('Visitor_portal/editMember/' . $crud->member_id); ?>" class="btn btn-warning">Edit</a>
                                <a href="<?php echo base_url('Visitor_portal/deleteMember/' . $crud->member_id); ?>" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete this member?');">Delete</a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="6" class="text-center">No records found.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    <!-- Display pagination links -->
    <div class="d-flex justify-content-center">
        <?php echo $pagination_links; ?>
    </div>
</div>




<!-- Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <form action="<?php echo base_url() ?>Visitor_portal/addMember" method="post">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Add Member</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div class="form-group">
         <label for="firstname">First Name</label> 
         <input type="text" name="firstname" placeholder="First Name" class="form-control">
         </div>
         <div class="form-group">
         <label for="lastname">Last Name</label> 
         <input type="text" name="lastname" placeholder="Last Name" class="form-control">
         <div class="form-group">
            <label for="gender">Gender</label>
            <select name="gender" class="form-control" required>
              <option value="">Select Gender</option> 
              <option value="Male">Male</option>
              <option value="Female">Female</option>

            </select>
          </div>
         <div class="form-group">
         <label for="email">Email</label> 
         <input type="text" name="email" placeholder="Email" class="form-control">
         </div>
         <div class="form-group">
         <label for="contact_no">Contact Number</label> 
         <input type="text" name="contact_no" placeholder="Contact Number" class="form-control">
         </div>

      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
        <input type="submit" name="insert" value="Add Member" class="btn btn-info"> 
      </div>
   </form>
    </div>
  </div>
</div>   
</div>

<?php if($this->session->flashdata('error')): ?>

    <div align="center" style="color: #FFF" class="btn-danger">
        <?php echo $this->session->flashdata('error'); ?>
    </div>
<?php endif; ?>

<?php if($this->session->flashdata('inserted')): ?>
    <div align="center" style="color: #FFF" class="btn-success">
        <?php echo $this->session->flashdata('inserted'); ?>
    </div>
<?php endif; ?>

<?php if($this->session->flashdata('updated')): ?>
    <div align="center" style="color: #FFF" class="btn-success">
        <?php echo $this->session->flashdata('updated'); ?>
    </div>
<?php endif; ?>

<?php if($this->session->flashdata('deleted')): ?>

    <div align="center" style="color: #FFF" class="btn-danger">
        <?php echo $this->session->flashdata('del'); ?>
    </div>
<?php endif; ?>




