<!-- views/visitor_portal/fullcalendar.php -->
<!DOCTYPE html>
<html>
<head>
    <title>Member Status Calendar</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/fullcalendar/3.4.0/fullcalendar.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.0.0-alpha.6/css/bootstrap.css" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.18.1/moment.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/fullcalendar/3.4.0/fullcalendar.min.js"></script>
    <script>
    $(document).ready(function() {
        // Initialize FullCalendar
        var calendar = $('#calendar').fullCalendar({
            editable: true,
            header: {
                left: 'prev,next today',
                center: 'title',
                right: 'month,agendaWeek,agendaDay'
            },
            events: "<?php echo base_url(); ?>fullcalendar/load",
            selectable: true,
            selectHelper: true,
            select: function(start, end, allDay) {
                var title = prompt("Enter Event Title");
                if (title) {
                    var start = $.fullCalendar.formatDate(start, "Y-MM-DD HH:mm:ss");
                    var end = $.fullCalendar.formatDate(end, "Y-MM-DD HH:mm:ss");
                    $.ajax({
                        url: "<?php echo base_url(); ?>fullcalendar/insert",
                        type: "POST",
                        data: { title: title, start: start, end: end },
                        success: function() {
                            calendar.fullCalendar('refetchEvents');
                            updateEventTable();
                            alert("Added Successfully");
                        }
                    })
                }
            },
            eventResize: function(event) {
                var start = $.fullCalendar.formatDate(event.start, "Y-MM-DD HH:mm:ss");
                var end = $.fullCalendar.formatDate(event.end, "Y-MM-DD HH:mm:ss");
                var title = event.title;
                var id = event.id;

                $.ajax({
                    url: "<?php echo base_url(); ?>fullcalendar/update",
                    type: "POST",
                    data: { title: title, start: start, end: end, id: id },
                    success: function() {
                        calendar.fullCalendar('refetchEvents');
                        updateEventTable();
                        alert("Event Updated");
                    }
                })
            },
            eventDrop: function(event) {
                var start = $.fullCalendar.formatDate(event.start, "Y-MM-DD HH:mm:ss");
                var end = $.fullCalendar.formatDate(event.end, "Y-MM-DD HH:mm:ss");
                var title = event.title;
                var id = event.id;

                $.ajax({
                    url: "<?php echo base_url(); ?>fullcalendar/update",
                    type: "POST",
                    data: { title: title, start: start, end: end, id: id },
                    success: function() {
                        calendar.fullCalendar('refetchEvents');
                        updateEventTable();
                        alert("Event Updated");
                    }
                })
            },
            eventClick: function(event) {
                if (confirm("Are you sure you want to remove it?")) {
                    var id = event.id;
                    $.ajax({
                        url: "<?php echo base_url(); ?>fullcalendar/delete",
                        type: "POST",
                        data: { id: id },
                        success: function() {
                            calendar.fullCalendar('refetchEvents');
                            updateEventTable();
                            alert('Event Removed');
                        }
                    })
                }
            }
        });

        // Update Event Table
        function updateEventTable() {
            $.ajax({
                url: "<?php echo base_url(); ?>fullcalendar/load",
                type: "GET",
                dataType: "json",
                success: function(events) {
                    var tableBody = $("#eventTable tbody");
                    tableBody.empty();
                    events.forEach(function(event) {
                        var row = `<tr>
                            <td>${event.id}</td>
                            <td>${event.title}</td>
                            <td>${event.start}</td>
                            <td>${event.end}</td>
                        </tr>`;
                        tableBody.append(row);
                    });
                }
            });
        }

        // Initial load of the event table
        updateEventTable();
    });
    </script>
</head>
<body>
    <style>
        body {
            background-color: #333333;
            color: #FFFFFF;
        }
    </style>
    <br />
    <div class="container">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h1 class="text-center flex-grow-1">Member Status Calendar</h1>
        <a href="<?= base_url() ?>visitor_portal/personal_information" class="btn btn-primary ms-3">Back</a>
    </div>
    <div id="calendar"></div>
    <br />
    <h2 align="center">Member Status</h2>
    <!-- Include event_table.php here -->
    <?php $this->load->view('visitor_portal/event_table'); ?>
</div>

</body>
<!--<footer class="py-4 bg-light mt-auto">-->
<!--    <div class="container-fluid px-4">-->
<!--        <div class="d-flex align-items-center justify-content-between small">-->
<!--            <div class="text-muted">Copyright &copy; IT Elective 2 2024</div>-->
<!--            <div>-->
<!--                <a href="#">Privacy Policy</a>-->
<!--                &middot;-->
<!--                <a href="#">Terms &amp; Conditions</a>-->
<!--            </div>-->
<!--        </div>-->
<!--    </div>-->
<!--</footer>-->
</html>
