<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Plyometrics and Cardio Programs</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <style type="text/css">
      body
      {
        background-image: url('<?= base_url() ?>asset/images/plyo.jpg');
        background-size: cover;
        background-attachment: fixed ;
      }
    </style>
    <div class="container mt-5">
        <div class="d-flex justify-content-center mb-4">
        <a href="<?= base_url() ?>visitor_portal" class="btn btn-secondary me-2">Back</a>
        <button onclick="window.print()" class="btn btn-primary">Print Program</button>
    </div>
        <h1 class="text-center mb-4">Plyometrics and Cardio Weekly Program</h1>

        <!-- Monday - Plyometric Power -->
        <div class="mb-5">
            <h2 class="text-center">Monday: Plyometric Power</h2>
            <table class="table table-striped table-bordered">
                <thead class="table-dark">
                    <tr>
                        <th>Exercise</th>
                        <th>Sets</th>
                        <th>Reps</th>
                        <th>Notes</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>Jump Squats</td>
                        <td>4</td>
                        <td>12</td>
                        <td>Land softly to protect your knees.</td>
                    </tr>
                    <tr>
                        <td>Box Jumps</td>
                        <td>3</td>
                        <td>10</td>
                        <td>Use a sturdy box or platform.</td>
                    </tr>
                    <tr>
                        <td>Lateral Bounds</td>
                        <td>3</td>
                        <td>12 (each side)</td>
                        <td>Focus on explosive lateral movements.</td>
                    </tr>
                </tbody>
            </table>
        </div>

        <!-- Tuesday - Cardio Endurance -->
        <div class="mb-5">
            <h2 class="text-center">Tuesday: Cardio Endurance</h2>
            <table class="table table-striped table-bordered">
                <thead class="table-dark">
                    <tr>
                        <th>Exercise</th>
                        <th>Duration</th>
                        <th>Intensity</th>
                        <th>Notes</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>Running</td>
                        <td>30 minutes</td>
                        <td>Moderate</td>
                        <td>Maintain a steady pace.</td>
                    </tr>
                    <tr>
                        <td>Jump Rope</td>
                        <td>10 minutes</td>
                        <td>High</td>
                        <td>Use interval patterns: 1 minute fast, 30 seconds slow.</td>
                    </tr>
                </tbody>
            </table>
        </div>

        <!-- Wednesday - Rest Day -->
        <div class="mb-5">
            <h2 class="text-center">Wednesday: Rest Day</h2>
            <p class="text-center">Take a break! Rest days are essential for recovery and muscle growth.</p>
        </div>

        <!-- Thursday - Explosive Strength -->
        <div class="mb-5">
            <h2 class="text-center">Thursday: Explosive Strength</h2>
            <table class="table table-striped table-bordered">
                <thead class="table-dark">
                    <tr>
                        <th>Exercise</th>
                        <th>Sets</th>
                        <th>Reps</th>
                        <th>Notes</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>Burpees</td>
                        <td>4</td>
                        <td>10</td>
                        <td>Keep the movements fluid and explosive.</td>
                    </tr>
                    <tr>
                        <td>Broad Jumps</td>
                        <td>3</td>
                        <td>8</td>
                        <td>Jump as far forward as possible, landing softly.</td>
                    </tr>
                </tbody>
            </table>
        </div>

        <!-- Friday - HIIT Cardio -->
        <div class="mb-5">
            <h2 class="text-center">Friday: HIIT Cardio</h2>
            <table class="table table-striped table-bordered">
                <thead class="table-dark">
                    <tr>
                        <th>Exercise</th>
                        <th>Work</th>
                        <th>Rest</th>
                        <th>Rounds</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>Sprint</td>
                        <td>30 seconds</td>
                        <td>60 seconds</td>
                        <td>8</td>
                    </tr>
                    <tr>
                        <td>High Knees</td>
                        <td>20 seconds</td>
                        <td>40 seconds</td>
                        <td>6</td>
                    </tr>
                </tbody>
            </table>
        </div>

        <!-- Saturday - Plyometric Circuit -->
        <div class="mb-5">
            <h2 class="text-center">Saturday: Plyometric Circuit</h2>
            <table class="table table-striped table-bordered">
                <thead class="table-dark">
                    <tr>
                        <th>Exercise</th>
                        <th>Sets</th>
                        <th>Reps</th>
                        <th>Notes</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>Jump Lunges</td>
                        <td>4</td>
                        <td>10 (each leg)</td>
                        <td>Explode upwards with each lunge.</td>
                    </tr>
                    <tr>
                        <td>Step-Ups (with Jump)</td>
                        <td>3</td>
                        <td>12 (each leg)</td>
                        <td>Use a sturdy platform or box.</td>
                    </tr>
                </tbody>
            </table>
        </div>

        <!-- Sunday - Rest or Light Cardio -->
        <div class="mb-5">
            <h2 class="text-center">Sunday: Rest or Light Cardio</h2>
            <p class="text-center">Optionally, go for a light walk or yoga session to promote recovery.</p>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
