<?php
	class Queries_staff extends CI_Model{

		public function getRoles()
		{
			$roles = $this->db->get('tbl_roles');
			if($roles->num_rows()>0){
				return $roles->result();
			}
		}

		public function searchStaff($firstname)
		{
		    $this->db->like('firstname', $firstname);
		    $query = $this->db->get('staff_crud');
		    return $query->result();
		}
		public function getAllStaff($staffdesc = "")
		{
		    $this->db->select("*");
		    $this->db->from("staff_crud");
		    if ($staffdesc != "") {
		        $this->db->like("firstname", $staffdesc, "both");
		        $this->db->or_like("lastname", $staffdesc, "both");
		        $this->db->or_like("email", $staffdesc, "both");
		        $this->db->or_like("contact_no", $staffdesc, "both");
		    }
		    $query = $this->db->get(); 
		    return $query->result(); // Return results as an array of objects
		}


		public function getStaff($fname = "")
		{
		    $this->db->select("*");
		    $this->db->from("staff_crud");
		    if ($fname != "") {
		        $this->db->like("firstname", $fname, "both");
		    }

		    $result = $this->db->get();
		    return $result->num_rows() > 0 ? $result->result_array() : [];
		}

		public function insertStaff($data)
		{
		    return $this->db->insert('staff_crud', $data);
		}



		public function getSingleStaff($staff_id)
		{
			$this->db->where('staff_id', $staff_id);
			$query = $this->db->get('staff_crud');
			if($query){

				return $query->row();
				
			}
		}


		public function updateStaff($data, $staff_id)
		{
			$this->db->where('staff_id', $staff_id);
			$query = $this->db->update('staff_crud',$data);

			if($query)
			{
				return true;
			}
			else 
			{
				return false;
			}

		}

		public function deleteStaff($staff_id)
		{
			$this->db->where('staff_id', $staff_id);
			$query = $this->db->delete('staff_crud');
			if($query)
			{
				return true;
			}
			else
			{
				return false;
			}
		}


}
	