<?php
	class Queries extends CI_Model{

		public function getRoles()
		{
			$roles = $this->db->get('tbl_roles');
			if($roles->num_rows()>0){
				return $roles->result();
			}
		}
		public function getAllMembers()
		{
			$query = $this->db->get('crud');
			if($query)
			{
				return $query->result();
			}
		}

		public function getMembers($keyword = "")
		{
		    $this->db->select("*");
		    $this->db->from("crud");

		    if ($keyword != "") {
		        $this->db->like("firstname", $keyword, "both");
		        $this->db->or_like("lastname", $keyword, "both");
		        $this->db->or_like("email", $keyword, "both");
		        $this->db->or_like("contact_no", $keyword, "both");
		    }

		    $result = $this->db->get();
		    return $result->num_rows() > 0 ? $result->result() : [];
		}

		public function getMembersCount($keyword = "")
		{
		    $this->db->from("crud");

		    if ($keyword != "") {
		        $this->db->like("firstname", $keyword, "both");
		        $this->db->or_like("lastname", $keyword, "both");
		        $this->db->or_like("email", $keyword, "both");
		        $this->db->or_like("contact_no", $keyword, "both");
		    }

		    return $this->db->count_all_results();
		}

		public function getMembersPaginated($keyword = "", $limit, $start)
		{
		    $this->db->select("*");
		    $this->db->from("crud");

		    if ($keyword != "") {
		        $this->db->like("firstname", $keyword, "both");
		        $this->db->or_like("lastname", $keyword, "both");
		        $this->db->or_like("email", $keyword, "both");
		        $this->db->or_like("contact_no", $keyword, "both");
		    }

		    $this->db->limit($limit, $start);
		    $query = $this->db->get();

		    return $query->num_rows() > 0 ? $query->result() : [];
		}


		public function insertMember()
		{
			$firstname = $this->input->post('firstname');
			$lastname = $this->input->post('lastname');
			$gender = $this->input->post('gender');
			$email = $this->input->post('email');
			$contact_no = $this->input->post('contact_no');

			$insertdata = array (
				'member_id' => null,
				'firstname' => $firstname,
				'lastname' => $lastname,
				'gender' => $gender,
				'email' => $email,
				'contact_no' => $contact_no
			);
			$result = $this->db->insert("crud", $insertdata);
			if($result)
				return true;
			else
				return false;
		}

		public function getSingleMember($member_id)
		{
			$this->db->where('member_id', $member_id);
			$query = $this->db->get('crud');
			if($query){

				return $query->row();
				
			}
		}

		public function updateMember($data, $member_id)
		{
			$this->db->where('member_id', $member_id);
			$query = $this->db->update('crud',$data);

			if($query)
			{
				return true;
			}
			else 
			{
				return false;
			}

		}

		public function deleteItem($member_id)
		{
			$this->db->where('member_id', $member_id);
			$query = $this->db->delete('crud');
			if($query)
			{
				return true;
			}
			else
			{
				return false;
			}
		}

	


}
	