<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class ElectiveModel extends CI_Model {
	public function getSubjects($limit, $start, $subdesc = ""){
		$this->db->select("*");
		$this->db->from('subject');

		if($subdesc !="")
			$this->db->like("subjectdesc", $subdesc, "both");

		$this->db->limit($limit, $start); 		
		$result = $this->db->get();

		if($result)
			return $result->result_array();
		else
			return false;
	}

	public function countSubjects($subdesc = ""){
		$this->db->select("*");
		$this->db->from('subject');

		if($subdesc !="")
		$this->db->like("subjectdesc", $subdesc, "both");
			
		$result = $this->db->get();

		
			return $result->num_rows();
	}

	public function insertSubject(){
		$subjectcode = $this->input->post('subjectcode');
		$subjectdesc = $this->input->post('subjectdesc');
		$subjectunit = $this->input->post('subjectunit');

		$insertdata = array (
			'subjectid' => null,
			'subjectcode' => $subjectcode,
			'subjectdesc' => $subjectdesc,
			'subjectunit' => $subjectunit
		);
		$result = $this->db->insert("subject", $insertdata);
		if($result)
			return true;
		else
			return false;
	}

	public function getSubject($subjectid){
		$this->db->select("*");
		$this->db->from('subject');

		$this->db->where("subjectid", $subjectid);		
		$result = $this->db->get();

		if($result)
			return $result->row_array();
		else
			return false;
	}

	public function updatesubject(){
		$subjectcode = $this->input->post('subjectcode');
		$subjectdesc = $this->input->post('subjectdesc');
		$subjectunit = $this->input->post('subjectunit');
		$subjectid = $this->input->post('subjectid');

		$insertdata = array (
			'subjectcode' => $subjectcode,
			'subjectdesc' => $subjectdesc,
			'subjectunit' => $subjectunit
		);
		$this->db->where("subjectid", $subjectid);
		$result = $this->db->update("subject", $insertdata);
		if($result)
			return true;
		else
			return false;
	}
}	