<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Visitor_portal extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('Queries');
		$this->load->model('Queries_staff');
		$this->load->model('fullcalendar_model');
		$this->load->helper('form');
		$this->load->library('form_validation');
		$this->load->library('pagination');

		$this->load->model('account_model');

		$is_logged_in = $this->account_model->is_user_logged_in();

		if( $is_logged_in)
		{
			if($_SESSION['role'] != USER_ROLE_VISITOR)
			{
				redirect('/');
			}
			
		}
		else
		{
			redirect('/');
		}
	}


	public function index()
	{
		
		$this->load->view('visitor_portal/header');
		$this->load->view('visitor_portal/index');
		$this->load->view('visitor_portal/footer');
		
	}

	public function displayMembers()
	{
      
	    $this->load->model('Member_model'); 
	    $data['member_information'] = $this->Member_model->getAllMembers();
	    $this->load->view('personal_information', $data);
  
	}

	public function personal_information()
	{
	    $this->load->library('pagination'); // Load the pagination library

	    // Get search keyword
	    $searchKeyword = $this->input->post('searchKeyword') ?? $this->input->get('searchKeyword');
	    $submitSearchReset = $this->input->post('submitSearchReset');

	    if (isset($submitSearchReset)) {
	        $searchKeyword = ""; // Clear search keyword
	    }

	    // Set base URL for pagination
	    $config['base_url'] = base_url('Visitor_portal/personal_information');
	    $config['total_rows'] = $this->Queries->getMembersCount($searchKeyword); // Get total rows
	    $config['per_page'] = 5; // Number of records per page
	    $config['uri_segment'] = 3; // URI segment for page number

	    // Custom pagination styles (Bootstrap 4 example)
	    $config['full_tag_open'] = '<nav><ul class="pagination justify-content-center">';
	    $config['full_tag_close'] = '</ul></nav>';
	    $config['attributes'] = ['class' => 'page-link'];
	    $config['first_link'] = 'First';
	    $config['last_link'] = 'Last';
	    $config['first_tag_open'] = '<li class="page-item">';
	    $config['first_tag_close'] = '</li>';
	    $config['prev_link'] = '&laquo';
	    $config['prev_tag_open'] = '<li class="page-item">';
	    $config['prev_tag_close'] = '</li>';
	    $config['next_link'] = '&raquo';
	    $config['next_tag_open'] = '<li class="page-item">';
	    $config['next_tag_close'] = '</li>';
	    $config['last_tag_open'] = '<li class="page-item">';
	    $config['last_tag_close'] = '</li>';
	    $config['cur_tag_open'] = '<li class="page-item active"><a href="#" class="page-link">';
	    $config['cur_tag_close'] = '</a></li>';
	    $config['num_tag_open'] = '<li class="page-item">';
	    $config['num_tag_close'] = '</li>';

	    $this->pagination->initialize($config);

	    // Get page number from URL or default to 0
	    $page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;

	    // Fetch data
	    $data['member_information'] = $this->Queries->getMembersPaginated($searchKeyword, $config['per_page'], $page);
	    $data['pagination_links'] = $this->pagination->create_links(); // Generate pagination links
	    $data['searchKeyword'] = $searchKeyword;

	    $this->load->view('visitor_portal/header');
	    $this->load->view('visitor_portal/personal_information', $data);
	    $this->load->view('visitor_portal/footer');
	}




	public function addMember()
	{
		
		$this->form_validation->set_rules('firstname', 'First Name', 'trim|required');
		$this->form_validation->set_rules('lastname', 'Last Name', 'trim|required');
		$this->form_validation->set_rules('gender', 'Gender', 'trim|required');
		$this->form_validation->set_rules('email', 'Email', 'trim|required');
		$this->form_validation->set_rules('contact_no', 'Contact Number', 'trim|required');

		if($this->form_validation->run()==false){

			$data_error = [

				'error' => validation_errors()

			];

			$this->session->set_flashdata($data_error);
		}
		else
		{
	        $result = $this->Queries->insertMember([

	        	'firstname' => $this->input->post('firstname'),
	            'lastname' => $this->input->post('lastname'),
	            'gender' => $this->input->post('gender'),
	            'email' => $this->input->post('email'),
	            'contact_no' => $this->input->post('contact_no')
	            
	        ], $member_id);

	            
	        if($result)
	        {
	        	$this->session->set_flashdata('inserted', 'Member added successfully.');
	        }

		}
		redirect('visitor_portal/personal_information');
		
	}
	public function profile_information()
	{
		
		//$this->load->view('visitor_portal/header');
		$this->load->view('visitor_portal/profile_information');
		//$this->load->view('visitor_portal/footer');
		
	}
	public function payment_information()
	{
		
		$this->load->view('visitor_portal/header');
		$this->load->view('visitor_portal/payment_information');
		$this->load->view('visitor_portal/footer');
		
	}

    
	public function staff_information()
	{
	    $this->load->model('Queries_staff'); // Ensure the model is loaded

	    if ($this->input->post('submitSearch')) {
	        $searchKeyword = $this->input->post('searchKeyword');
	        var_dump($searchKeyword); // Add this line to see what's being sent
	        $data['employee_information'] = $this->Queries_staff->getAllStaff($searchKeyword); // Fetch staff data based on search query
	    } else {
	        $data['employee_information'] = $this->Queries_staff->getAllStaff(); // Fetch all staff data when page is loaded
	    }

	    $this->load->view('visitor_portal/header');
	    $this->load->view('visitor_portal/staff_information', $data); // Pass data to the view
	    $this->load->view('visitor_portal/footer');
	}


	public function editMember($member_id)
	{
		$data['singleMember'] = $this->Queries->getSingleMember($member_id);

		$this->load->view('visitor_portal/edit_view', $data);
	}

	public function update($member_id)
	{
		
		$this->form_validation->set_rules('firstname', 'First Name', 'trim|required');
		$this->form_validation->set_rules('lastname', 'Last Name', 'trim|required');
		$this->form_validation->set_rules('gender', 'Gender', 'trim|required');
		$this->form_validation->set_rules('email', 'Email', 'trim|required');
		$this->form_validation->set_rules('contact_no', 'Contact Number', 'trim|required');

		if($this->form_validation->run()==false){

			$data_error = [

				'error' => validation_errors()

			];

			$this->session->set_flashdata($data_error);
		}
		else
		{
	        $result = $this->Queries->updateMember([

	        	'firstname' => $this->input->post('firstname'),
	            'lastname' => $this->input->post('lastname'),
	            'gender' => $this->input->post('gender'),
	            'email' => $this->input->post('email'),
	            'contact_no' => $this->input->post('contact_no')
	            
	        ], $member_id);

	            
	        if($result)
	        {
	        	$this->session->set_flashdata('updated', 'Member updated successfully.');
	        }

		}
		redirect('visitor_portal/personal_information');
		
	}

	public function deleteMember($member_id)
	{
		
	    $result = $this->Queries->deleteItem($member_id);

	    if($result == true )
	    {
	    	$this->session->set_flashdata('deleted', 'Member has been deleted!');
	    }
	    redirect('visitor_portal/personal_information');
	    
	}

	public function member_status()
	{	
				$this->load->view('visitor_portal/header');
				$this->load->view('visitor_portal/member_status');
				$this->load->view('visitor_portal/footer');

	}
	public function fullcalendar()
	{	
				$this->load->view('visitor_portal/header');
				$this->load->view('visitor_portal/fullcalendar');
				$this->load->view('visitor_portal/footer');
	}






	public function bodybuilding()
	{

		$this->load->view('visitor_portal/bodybuilding');
		
	}
	public function calisthenics()
	{

		$this->load->view('visitor_portal/calisthenics');
		
	}
	public function yoga()
	{

		$this->load->view('visitor_portal/yoga');

		
	}
	public function cardio()
	{

		$this->load->view('visitor_portal/cardio');
		
	}

}