<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Staff_controller extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('Queries_staff');
		$this->load->model('account_model');
		
		$is_logged_in = $this->account_model->is_user_logged_in();

		if( $is_logged_in)
		{
			if($_SESSION['role'] != USER_ROLE_VISITOR)
			{
				redirect('/');
			}
				
		}
		else
		{
			redirect('/');
		}
	}


	public function index()
	{
		$this->load->model('Queries_staff'); 
	    $data['employee_information'] = $this->Queries_staff->getAllStaff(); 
	    $this->load->view('visitor_portal/header');
	    $this->load->view('visitor_portal/staff_information', $data); 
	    $this->load->view('visitor_portal/footer');


	}

	public function displayStaff()
	{
	    $this->load->model('Queries_staff');
	    $data['employee_information'] = $this->Queries_staff->getAllStaff($staffdesc); // Pass $staffdesc
	    $this->load->view('staff_information', $data);
	}


	public function staff_information()
	{
	    // Load the model
	    $this->load->model('Queries_staff');

	    // Retrieve search keyword
	    $searchKeyword = $this->input->post('searchKeyword');
	    if ($this->input->post('submitSearchReset')) {
	        $searchKeyword = ""; // Clear search keyword on reset
	    }

	    // Fetch filtered staff data
	    $data['employee_information'] = $this->Queries_staff->getAllStaff($searchKeyword);

	    // Load views with data
	    $this->load->view('visitor_portal/header');
	    $this->load->view('visitor_portal/staff_information', $data); 
	    $this->load->view('visitor_portal/footer');
	}


	public function addStaff()
	{
	    // Load the model
	    $this->load->model('Queries_staff');

	    // Get POST data
	    $data = array(
	        'firstname' => $this->input->post('firstname'),
	        'lastname'  => $this->input->post('lastname'),
	        'gender'    => $this->input->post('gender'),
	        'email'     => $this->input->post('email'),
	        'contact_no'=> $this->input->post('contact_no')
	    );

	    // Insert into database
	    $result = $this->Queries_staff->insertStaff($data);

	    // Handle success or failure
	    if ($result) {
	        $this->session->set_flashdata('success', 'Staff added successfully!');
	    } else {
	        $this->session->set_flashdata('error', 'Failed to add staff.');
	    }

	    // Redirect back to the staff page
	    redirect('Staff_controller/staff_information');
	}

	public function editStaff($staff_id)
	{
		$data['singleStaff'] = $this->Queries_staff->getSingleStaff($staff_id);

		$this->load->view('visitor_portal/edit_staff', $data);
	}


	public function update($staff_id)
	{
		
		$this->form_validation->set_rules('firstname', 'First Name', 'trim|required');
		$this->form_validation->set_rules('lastname', 'Last Name', 'trim|required');
		$this->form_validation->set_rules('gender', 'Gender', 'trim|required');
		$this->form_validation->set_rules('email', 'Email', 'trim|required');
		$this->form_validation->set_rules('contact_no', 'Contact Number', 'trim|required');

		if($this->form_validation->run()==false){

			$data_error = [

				'error' => validation_errors()

			];

			$this->session->set_flashdata($data_error);
		}
		else
		{
	        $result = $this->Queries_staff->updateStaff([

	        	'firstname' => $this->input->post('firstname'),
	            'lastname' => $this->input->post('lastname'),
	            'gender' => $this->input->post('gender'),
	            'email' => $this->input->post('email'),
	            'contact_no' => $this->input->post('contact_no')
	            
	        ], $staff_id);

	            
	        if($result)
	        {
	        	$this->session->set_flashdata('updated', 'Staff updated successfully.');
	        }

		}
		redirect('visitor_portal/staff_information');
		
	}

	public function deleteStaff($staff_id)
	{
		
	    $result = $this->Queries_staff->deleteStaff($staff_id);

	    if($result == true )
	    {
	    	$this->session->set_flashdata('deleted', 'Staff has been deleted!');
	    }
	    redirect('visitor_portal/staff_information');
	    
	}

	public function member_status($eventtitle)
	{
		
			$eventtitle = urldecode($eventtitle);
			$mems = $this->Queries->getEvent($eventtitle);
			if($subs){
				$data['eventid'] = $mems['eventid'];
				$data['eventtitle'] = $mems['eventtitle'];
				$data['eventstartdate'] = $mems['eventstartdate'];
				$data['eventenddate'] = $mems['eventenddate'];
				

				$this->load->view('visitor_portal/header');
				$this->load->view('visitor_portal/member_status', $data);
				$this->load->view('visitor_portal/footer');
			}else
				redirect(base_url()."event");
		
	}


}