<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Elective_Controller extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('ElectiveModel');
        
    }

    public function adminRegister(){
    	$this->load->model('queries');
    	$roles = $this->queries->getRoles();
    	$this->load->view('register',['roles'=>$roles]);
    }

    public function adminSignup(){
		$this->form_validation->set_rules('username', 'Username', 'Required');
		$this->form_validation->set_rules('email', 'Email', 'Required');
		$this->form_validation->set_rules('gender', 'Gender', 'Required');
		$this->form_validation->set_rules('role_id', 'Role', 'Required');
		$this->form_validation->set_rules('password', 'Password', 'Required');
		$this->form_validation->set_rules('confpwd', 'Password Again', 'Required');
		$this->form_validation->set_error_delimiters('<div class ="text-danger">','</div>'
			);
		if ($this->form_validation->run()) {
		    echo 'Validation Passed';
		}else {
		    $this->adminRegister();
		}
		

	}




    public function index() {
        $this->load->view('templates/header');
        $this->load->view('templates/adminmenus');
        $this->load->view('adminpages/body');
        $this->load->view('templates/footer');
    }


     public function getSubjects() {
     	$subdesc = "";
     	if($this->input->post('filtersubject') != NULL){
     		$subdesc = $this->input->post("subjectdesc" ,true);
     		$subdesc = !empty($subdesc) ? $subdesc : "";

     			$filterdata = array(
     				'subdesc' => $subdesc
     			);
     			$this->session->set_userdata('filterdata' , $filterdata);
		}else{
			$filterdata = $this->session->userdata('filterdata');
			$subdesc = !empty($filterdata['subdesc']) ? $filterdata['subdesc'] : "";
		}

		if($this->input->post('clearsubject') != NULL){
			
			$this->session->unset_userdata('filterdata');
			$subdesc = "";
		}	

		$recordno = 5;
			$config = array();
	       	$config["base_url"] = base_url() . "subject";
	       	$config["total_rows"] = $this->ElectiveModel->countSubjects($subdesc);
	       	$config["per_page"] = $recordno;
	       	$config["uri_segment"] = 2;

	       	$config['full_tag_open'] = '<ul class="pagination">';
	       	$config['full_tag_close'] = '</ul>';
	       	$config['first_link'] = 'First';
	       	$config['last_link'] = 'Last';
	       	$config['first_tag_open'] = '<li class="page-item"><span class="page-link">';
	       	$config['first_tag_close'] = '</span></li>';
	       	$config['prev_link'] = '&laquo';
	       	$config['prev_tag_open'] = '<li class="page-item"><span class="page-link">';
	       	$config['prev_tag_close'] = '</span></li>';
	       	$config['next_link'] = '&raquo';
	       	$config['next_tag_open'] = '<li class="page-item"><span class="page-link">';
	       	$config['next_tag_close'] = '</span></li>';
	       	$config['last_tag_open'] = '<li class="page-item"><span class="page-link">';
	       	$config['last_tag_close'] = '</span></li>';
	       	$config['cur_tag_open'] = '<li class="page-item active"><a class="page-link" href="#">';
	       	$config['cur_tag_close'] = '</a></li>';
	       	$config['num_tag_open'] = '<li class="page-item"><span class="page-link">';
	       	$config['num_tag_close'] = '</span></li>';

	       	$this->pagination->initialize($config);
	       	$page = ($this->uri->segment(2)) ? $this->uri->segment(2) : 0;
	       	$data['count'] = $page;
	       	$data['total'] =$this->ElectiveModel->countSubjects($subdesc);

	       	$config['last_tag_close']='</li>';

	       	$data['links'] = $this->pagination->create_links();

	       	$data['subs'] = $this->ElectiveModel->getSubjects($config['per_page'], $page, $subdesc);
  			$data['cnt'] = $page + 1;
       $data['subjectdesc'] = $subdesc;
       $this->load->view('templates/header');
       $this->load->view('templates/adminmenus');
       $this->load->view('adminpages/subject',$data);
       $this->load->view('templates/footer');
    }

     public function addsubject() {
       
       $this->load->view('templates/header');
       $this->load->view('templates/adminmenus');
       $this->load->view('adminpages/addsubject');
       $this->load->view('templates/footer');
    }

    public function savesubject() {
      $result = $this->ElectiveModel->insertSubject();

      if($result){
      	$flashmessage = array(
      		'message' => 'New Subject Inserted.',
      		'status' => 'positive'
      	);
      		$this->session->set_userdata('flashmessage', $flashmessage);
      }else{
      	$flashmessage = array(
      		'message' => 'error encountered.',
      		'status' => 'negative'
      	);
      	$this->session->set_userdata('flashmessage', $flashmessage);
      }	
      	redirect(base_url()."subject");
    }

    public function editsubject($subjectid) {
       	$subs = $this->ElectiveModel->getSubject($subjectid);
       	if($subs){
       	$data['subjectid']  = $subs['subjectid'];
       	$data['subjectcode']  = $subs['subjectcode'];
		$data['subjectdesc']  = $subs['subjectdesc'];
		$data['subjectunit']  = $subs['subjectunit'];
       $this->load->view('templates/header');
       $this->load->view('templates/adminmenus');
       $this->load->view('adminpages/editsubject', $data);
       $this->load->view('templates/footer');
       	}else{
       	redirect(base_url()."subject");	redirect();

       	}
    }

       public function updatesubject() {
      $result = $this->ElectiveModel->updateSubject();

      if($result){
      	$flashmessage = array(
      		'message' => 'New Subject Inserted.',
      		'status' => 'positive'
      	);
      		$this->session->set_userdata('flashmessage', $flashmessage);
      }else{
      	$flashmessage = array(
      		'message' => 'error encountered.',
      		'status' => 'negative'
      	);
      	$this->session->set_userdata('flashmessage', $flashmessage);
      }	
      	redirect(base_url()."subject");
    }
}

